unit PagShow;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, SO_Unit, HW, ExtCtrls;

type
  TFShowPag = class(TForm)
    MemoPag: TMemo;
    Panel1: TPanel;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    function Execute(IndexPagMem:integer):boolean;
    { Public declarations }
  end;

var
  FShowPag: TFShowPag;

implementation

{$R *.DFM}

{ TForm1 }

function TFShowPag.Execute(IndexPagMem:integer): boolean;
var i, j, k:integer;
    instrucao:String;
    PPagina:pointer_Pagina;
    PBCP:pointer_BCP;
begin
  case Memoria.Bitmap[IndexPagMem] of
    0:begin
        Result:=False;
        Exit;
    end;
    1:begin  // Mostra Tabela de Pginas
       MemoPag.Clear;

       PBCP:=Nil;
       for i:=3 to 6 do begin
          for j:=0 to Estado[i].Count-1 do
             if pointer_BCP(Estado[i].Items[j]).Tab_Pag=IndexPagMem then begin
                 PBCP:=Estado[i].Items[j];
                 Break;
             end;
          if PBCP<>Nil then Break;
       end;

       PPagina:=@Memoria.Items[IndexPagMem];
       MemoPag.Lines.Add(Format('Pg. %2d - Tabela'+#13#10+'Job %4d'+#13#10, [IndexPagMem, PBCP^.Job]));
       for i:= 0 to tam_pagina-1 do  MemoPag.Lines.Add(Format('%5d%6d', [PPagina^[i].c1, PPagina^[i].c2]));

       Top:=Mouse.CursorPos.y;
       Left:=Mouse.CursorPos.x - Width;
       ShowModal;
    end;
    2: begin // Mostra Pgina do Cdigo
         MemoPag.Clear;

         PBCP:=Nil;
         for i:=3 to 6 do begin
            for j:=0 to Estado[i].Count-1 do begin
               PPagina:=@Memoria.Items[pointer_BCP(Estado[i].Items[j]).Tab_Pag];
               for k:=0 to tam_pagina-1 do
                   if PPagina^[k].c2=IndexPagMem then begin
                      PBCP:=Estado[i].Items[j];
                      Break;
                   end;
               if PBCP<>Nil then Break;
            end;
            if PBCP<>Nil then Break;
         end;

         PPagina:=@Memoria.Items[IndexPagMem];
         MemoPag.Lines.Add(Format('Pg. %2d - Cdigo'+#13#10+'Job %4d'+#13#10+'Tab. %2d'+#13#10, [IndexPagMem, PBCP^.Job, PBCP^.Tab_Pag]));
         for i:= 0 to tam_pagina-1 do begin
           if (PPagina^[i].c1<0) or (PPagina^[i].c1>num_instr-1) then instrucao := 'XXX'
           else instrucao := INSTR[PPagina^[i].c1];

            MemoPag.Lines.Add(Format('%5s%4d%4d', [instrucao, PPagina^[i].c2, PPagina^[i].c3]));
         end;
         Top:=Mouse.CursorPos.y;
         Left:=Mouse.CursorPos.x - Width;
         ShowModal;
    end;

    3:begin // Mostra Pgina de Dados
        MemoPag.Clear;

        PBCP:=Nil;
        for i:=3 to 6 do begin
            for j:=0 to Estado[i].Count-1 do begin
               PPagina:=@Memoria.Items[pointer_BCP(Estado[i].Items[j]).Tab_Pag];
               for k:=0 to tam_pagina-1 do
                   if PPagina^[k].c2=IndexPagMem then begin
                      PBCP:=Estado[i].Items[j];
                      Break;
                   end;
               if PBCP<>Nil then Break;
            end;
            if PBCP<>Nil then Break;
        end;

        PPagina:=@Memoria.Items[IndexPagMem];
        MemoPag.Lines.Add(Format('Pg. %2d -  Dados'+#13#10+'Job %4d'+#13#10+'Tab. %2d'+#13#10, [IndexPagMem, PBCP^.Job, PBCP^.Tab_Pag]));
        for i:= 0 to tam_pagina-1 do
           MemoPag.Lines.Add(Format('%10d', [PPagina^[i].c1]));

        Top:=Mouse.CursorPos.y;
        Left:=Mouse.CursorPos.x - Width;
        ShowModal;
    end;
  end;
   Result:=True;
end;

procedure TFShowPag.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   close;
end;

procedure TFShowPag.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 close;
end;

end.
